#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <limits.h>

struct Point {
    long long x, y;
    bool operator==(const Point& a) const {
        return x == a.x && y == a.y;
    }
};

long long orientation(const Point& p, const Point& q, const Point& r) {
    long long val = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    if (val == 0) return 0;
    return (val > 0) ? 1 : 2;
}

long long distSq(const Point& p1, const Point& p2) {
    return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
}

Point p0;
bool compare(const Point& p1, const Point& p2) {
    long long o = orientation(p0, p1, p2);
    if (o == 0)
        return distSq(p0, p1) < distSq(p0, p2);
    return o == 2;
}

std::vector<Point> grahamScan(std::vector<Point>& points) {
    long long n = points.size();

    long long miny = 0;
    for (long long i = 1; i < n; ++i) {
        if (points[i].y < points[miny].y || (points[i].y == points[miny].y && points[i].x < points[miny].x)) {
            miny = i;
        }
    }
    std::swap(points[0], points[miny]);
    p0 = points[0];

    std::sort(points.begin() + 1, points.end(), compare);

    std::vector<Point> hull;
    hull.push_back(points[0]);
    hull.push_back(points[1]);
    hull.push_back(points[2]);

    for (long long i = 3; i < n; ++i) {
        while (hull.size() > 1 && orientation(hull[hull.size() - 2], hull.back(), points[i]) != 2) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }

    return hull;
}

int main() {
    std::vector<Point> points;
    long long n;

    std::cin >> n;

    for (long long i = 0; i < n; ++i) {
        Point p;
        std::cin >> p.x >> p.y;
        points.push_back(p);
    }

    std::vector<Point> hull = grahamScan(points);
    std::vector<long long> povrs = {};
    for (long long i = 0; i < hull.size(); i++) {
        Point s = hull[i];
        std::vector<Point> points1 = points;
        points1.erase(std::remove(points1.begin(), points1.end(), s), points1.end());

        std::vector<Point> hull1 = grahamScan(points1);
        long long a = 0;
        long long n1 = hull1.size();
        for (long long k = 0; k < n1; ++k) {
            long long j = (k + 1) % n1;
            a += hull1[k].x * hull1[j].y - hull1[k].y * hull1[j].x;
        }
        points.push_back(s);
        povrs.push_back(std::abs(a) / 2);
    }

    long long min = LLONG_MAX;
    for (long long i = 0; i < povrs.size(); i++) {
        if (povrs[i] < min) {
            min = povrs[i];
        }
    }
    std::cout << min << '\n';
    return 0;
}